#version 430

layout (location = 0) in vec3 VertexPosition;
layout (location = 1) in vec2 TextureCoords;
layout (location = 2) in vec3 VertexNormal;

out vec3 VertPos; //Vertex position in eye coords
out vec2 TexCoords;
out vec3 N; //Transformed normal

uniform mat4 NormalMatrix;
uniform mat4 M;
uniform mat4 MV;
uniform mat4 MVP;

void main()
{
	VertPos = vec3(M * vec4(VertexPosition,1.0));
	TexCoords = TextureCoords;
	mat3 NormMatrix = transpose(inverse(mat3(M)));
	N = normalize(vec3(NormMatrix * VertexNormal));
	gl_Position = MVP * vec4(VertexPosition,1.0);
}